clear all
close all
clc

% Viene caricato il file contenente i dati relativi all'incendio
load('incendio.mat');
i = 0;
% Viene controllato che i dati inseriti siano validi
while i == 0
    switch true
        case isempty(estensione) || estensione <= 0
            % Viene mostrato un messaggio di errore
            error('L''estensione non  valida.');
        case ~isempty(personale) && personale <= 0
            % Viene mostrato un messaggio di errore
            error('Il numero di personale non  valido.');
        case ~isempty(mezzi) && mezzi < 0
            % Viene mostrato un messaggio di errore
            error('Il numero di mezzi non  valido.');
        case ~isempty(CL415) && CL415 < 0
            % Viene mostrato un messaggio di errore
            error('Il numero di CL415 non  valido.');
        case ~isempty(S64F) && S64F < 0
            % Viene mostrato un messaggio di errore
            error('Il numero di S64F non  valido.');
        case isempty(zona) || zona < 1 || zona > 3
            % Viene mostrato un messaggio di errore
            error('La zona non  valida.');
        case isempty(vegetazione) || vegetazione < 1 || vegetazione > 3
            % Viene mostrato un messaggio di errore
            error('Il tipo di vegetazione non  valido.');
        case stagione < 1 || stagione > 3
            % Viene mostrato un messaggio di errore
            error('La stagione non  valida.');
        otherwise
            disp('Variabili salvate con successo.');
            i = 1;
    end
end

% Scelta dell'equazione per ricavare il personale della squadra

% Viene verificato se il numero di personale  mancante
if isempty(personale)
    % Se il numero di personale  mancante, si procede a stimarlo
    
    % Viene verificato se la stagione  disponibile
    if isempty(stagione) == 0 
        % Se la stagione  disponibile, si utilizza un'equazione di regressione lineare
        % per calcolare il numero di personale
        % Equazione ricavata tramite regressione lineare con variabili: estensione, zona, stagione, vegetazione
        personale = round(-56.346 + 0.010*estensione + 21.917*zona + 1.5*stagione + 13.679*vegetazione); % R^2 = 0.84
    else
        % Se la stagione non  disponibile, si utilizza un'altra equazione di regressione lineare
        % per calcolare il numero di personale
        % Equazione ricavata tramite regressione lineare con variabili: estensione, zona, vegetazione
        personale = round(-54.358 + 0.010*estensione + 22.529*zona + 13.973*vegetazione); % R^2 = 0.83
    end
end

% Scelta dell'equazione per ricavare il numero di CL415 necessari

% Viene verificato se il numero di CL415  mancante
if isempty(CL415)
    % Se il numero di CL415  mancante, si procede a stimarlo
    
    % Viene verificato se la stagione  disponibile
    if isempty(stagione) == 0 
        % Se la stagione  disponibile, si utilizza un'equazione di regressione lineare
        % per calcolare il numero di CL415
        % Equazione ricavata tramite regressione lineare con variabili: estensione, zona, vegetazione, stagione
        CL415 = round(-5.440 - 0.0002*estensione + 1.862*zona + 1.608*vegetazione - 0.109*stagione); % R^2 = 0.71
    else
        % Se la stagione non  disponibile, si utilizza un'altra equazione di regressione lineare
        % per calcolare il numero di CL415
        % Equazione ricavata tramite regressione lineare con variabili: estensione, zona, vegetazione
        CL415 = round(-5.584 - 0.0002*estensione + 1.818*zona + 1.586*vegetazione); % R^2 = 0.71
    end
end

% Scelta dell'equazione per ricavare il numero di S64F necessari

% Viene verificato se il numero di S64F  mancante
if isempty(S64F)
    % Se il numero di S64F  mancante, si procede a stimarlo
    
    % Viene verificato se la stagione  disponibile
    if isempty(stagione) == 0 
        % Se la stagione  disponibile, si utilizza un'equazione di regressione lineare
        % per calcolare il numero di S64F
        % Equazione ricavata tramite regressione lineare con variabili: estensione, zona, vegetazione, stagione
        S64F = ceil(0.000117*estensione + 0.097759*zona + 0.383251*vegetazione - 0.1375*stagione); % R^2 = 0.65
    else
        % Se la stagione non  disponibile, si utilizza un'altra equazione di regressione lineare
        % per calcolare il numero di S64F
        % Equazione ricavata tramite regressione lineare con variabili: estensione, zona, vegetazione
        S64F = ceil(0.000128*estensione - 0.00441*zona + 0.31301*vegetazione); % R^2 = 0.65
    end
end

% Viene verificato se CL415 o S64F sono maggiori di zero
if CL415 > 0 || S64F > 0 
    % Se almeno uno tra CL415 e S64F  maggiore di zero, viene impostato il DOS a 1
    DOS = 1;
else
    % Altrimenti, viene impostato il DOS a 0
    DOS = 0;
end

% Viene calcolato il numero di personale escluso il DOS
personale = personale - DOS;

% Viene calcolato il numero di caposquadra
crew_capo_sq = ceil(personale/4);

% Viene calcolato il numero di membri dell'equipaggio dei vigili del fuoco
% esclusi i caposquadra
crew_vvf = personale - crew_capo_sq;

% Chiedi all'utente di inserire una lettera tra A e E
nazione = input('Inserire ITA per la tariffa oraria italiana o EU per la tariffa oraria media europea: ', 's');

% Creazione del nome del file in base alla lettera inserita
switch nazione
    case 'ITA'
        % Costo orario per i vigili del fuoco
        costh_vvf = 23;

        % Costo orario per il caposquadra
        costh_capo_sq = 25;

        % Costo orario per il DOS
        costh_DOS = 27;
    case 'EU'
        % Costo orario per i vigili del fuoco
        costh_vvf = 20;

        % Costo orario per il caposquadra
        costh_capo_sq = 22;

        % Costo orario per il DOS
        costh_DOS = 24;
    otherwise
        error('Selezione non valida. Devi inserire un valore tra ITA e EU.');
end

% Costo orario per l'autobotte
costh_autobotte = 60;

% Costo totale per l'utilizzo di un CL415 (comprensivo di utilizzo e carburante)
costh_CL415 = 9144;

% Costo totale per l'utilizzo di un S64F (comprensivo di utilizzo e carburante)
costh_S64F = 5292;

% Viene calcolato il costo totale orario del personale e dei mezzi
costh_tot_personale = costh_vvf * crew_vvf + costh_capo_sq * crew_capo_sq + costh_DOS * DOS + costh_autobotte * crew_capo_sq;

% Viene verificato se il numero di CL415  negativo e lo imposta a 0 se lo 
if CL415 < 0
    CL415 = 0;
end

% Viene verificato  se il numero di S64F  negativo e lo imposta a 0 se lo 
if S64F < 0
    S64F = 0;
end

% Viene calcolato il costo totale per i velivoli (CL415 e S64F)
costh_tot_velivoli = costh_CL415 * CL415 + costh_S64F * S64F;

% Viene calcolato il costo orario totale comprensivo di personale, attrezzature, mezzi e velivoli
costh_tot = costh_tot_personale + costh_tot_velivoli;

% Viene visualizzato il costo orario del personale, dei velivoli e del costo orario totale
fprintf('Il costo orario del personale  di %.2f .\nIl costo orario dei velivoli  di %.2f .\nIl costo orario totale  di %.2f .\n', costh_tot_personale, costh_tot_velivoli, costh_tot);

% Vengono controllate le variabili terreno, proprieta, CO2
variabili = {terreno, proprieta, CO2};
nomi_variabili = {'terreno', 'proprieta', 'CO2'};

for j = 1:numel(variabili)
    for i = 1:length(variabili{j})
        if variabili{j}(i) < 0
            error(sprintf('Il valore di %s alla posizione %d non  valido.', nomi_variabili{j}, i));
        end
    end
end


% Viene controllata la lunghezza dei vettori
if mod(length(terreno), 2) ~= 0
    error('Il vettore "terreno" deve avere una lunghezza pari.');
end

if mod(length(proprieta), 2) ~= 0
    error('Il vettore "proprieta" deve avere una lunghezza pari.');
end

if mod(length(CO2), 2) ~= 0
    error('Il vettore "CO2" deve avere una lunghezza pari.');
end

% Calcolo dei costi totali

% Inizializzazione delle somme
somma_terr = 0;
somma_prop = 0;
somma_CO2 = 0;

% Loop per moltiplicare i valori a coppie e sommare
for i = 1:2:length(terreno)
    switch terreno(i)
        case 1
            cost = 60000;
        case 2
            cost = 25500;
        case 3
            cost = 37000;
        case 4
            cost = 5000;
        otherwise
            error('Codice terreno non valido.');

    end
    somma_terr = somma_terr + cost * terreno(i+1);
end

for i = 1:2:length(proprieta)
    switch proprieta(i)
        case 1
            cost = 947;
        case 2
            cost = 1197;
        case 3
            cost = 1431;
        case 4
            cost = 2419;
        otherwise
            error('Codice propriet non valido.');        
    end
    somma_prop = somma_prop + cost * proprieta(i+1);
end

for i = 1:2:length(CO2)
    switch CO2(i)
        case 1
            cost = 0.8 * 0.5 * 81;
        case 2
            cost = 0.95 * 0.5 * 81;
        case 3
            cost = 0.6 * 0.5 * 81;
        case 4
            cost = 0.7 * 0.5 * 81;
        case 5
            cost = 0.8 * 0.5 * 81;
        case 6
            cost = 0.9 * 0.5 * 81;
        case 7
            cost = 1 * 0.5 * 81;
        case 8
            cost = 0.9 * 0.5 * 81;
        case 9
            cost = 0.6 * 0.5 * 81;
        otherwise
            error('Codice CO2 non valido.');
    end
    somma_CO2 = somma_CO2 + cost * CO2(i+1);
end

% Visualizzazione dei costi totali
fprintf('Il costo dei danni al terreno sar di %.2f .\nIl costo dei danni alle propriet sar di %.2f .\nIl costo dei danni dovuti all''emissione di CO2 sar di %.2f .\n', somma_terr, somma_prop, somma_CO2);
